<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */
    
    session_start();
    include "../../include/costanti.php";
    include "../../include/util.php";
    include "../../gUtil/DbManager.php";
    include "../../classi/ecommerce/GestoreAccessi.php";
    include "../../classi/ecommerce/Carrello.php";

    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);

    $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
    $email      = filter_input(INPUT_GET,"email",FILTER_SANITIZE_EMAIL);
    $password   = hash("sha512",$_GET['password']);
    $gestoreAccessi = new GestoreAccessi($geecomDb, $idCarrello);
    
    if($operazione=="login") {
        $idUtente = $gestoreAccessi->loginUtente($email,$password);
        if($idUtente>0) {
            $_SESSION["geecomUser_id"]    = $idUtente;
            $_SESSION["geecomUser_email"] = $email;
            if(isset($_SESSION["carrello"])) { // se è presente un carrello associa l'utente al carrello
                $carrello = new Carrello($geecomDb, $_SESSION["carrello"]);
                $carrello->associaCarrelloUtente($idUtente);
            }
            
            $queryGruppo = "SELECT * FROM geec_gruppi WHERE id IN (SELECT idGruppo FROM geec_gruppiUtenti WHERE idUtente={$_SESSION["geecomUser_id"]}) LIMIT 1";
            $risnumMessaggi = $geecomDb->eseguiQueryLettura($queryGruppo);
            if($risnumMessaggi->num_rows>0) {
                $gruppo = $risnumMessaggi->fetch_assoc();
                $_SESSION["geecomUser_idGruppo"] = $gruppo["id"];
            }
            else {
                $_SESSION["geecomUser_idGruppo"] = 0;
            }
            echo "ok";
	}
	else {
            echo "utente non riconosciuto";
	}
    }
